Imports System.Windows.Forms

'
' AbstractLogon jest klas abstrakcyjn odpowiadajc za uwierzytelniania uytkownikw programu.
'
Public MustInherit Class AbstractLogon
    '
    ' Metoda Logon uwierzytelnia uytkownika.
    '
    ' programName  Nazwa nazwa programu, ktra powinna by wywietlana w pasku tytuu
    '               okna dialogowego dajcego podania danych uwierzytelniajcych.
    Public Sub Logon(ByVal programName As String)
        Dim authenticationToken As Object = Nothing
        Dim logonDialog As New LogonDialog()
        logonDialog.Text = "Zaloguj si w programie " & programName
        While True
            logonDialog.ShowDialog()
            Try
                Dim userId As String = logonDialog.UserId
                Dim password As String = logonDialog.Password
                authenticationToken = Authenticate(userId, password)
                Exit While
            Catch e As Exception
                ' Informuje uytkownika o braku moliwoci uwierzytelnienia.
                MessageBox.Show(e.ToString(), "Uwierzytelnienie uytkownika niemoliwe", MessageBoxButtons.OK)
            End Try
        End While

        ' Sygnalizuje pomylny przebieg procesu uwierzytelniania.
        NotifyAuthentication(authenticationToken)
    End Sub

    '
    ' Uwierzytelnia uytkownika wedug podanego przez uytkownika identyfikatora i hasa.
    '
    ' userID  Wpisany wpisany identyfikator uytkownika.
    ' password  Wpisane wpisane haso uytkownika.
    ' returns  Obiekt obiekt reprezentujcy ewentualne dane niezbdne
    '           do potwierdzenia prawidowego uwierzytelnienia
    '           danego uytkownika.
    Protected MustOverride Function Authenticate(ByVal userID As String, ByVal password As String) As Object

    '
    ' Powiadamia pozostae skadniki programu, e dany uytkownik zosta
    ' prawidowo uwierzytelniony.
    '
    ' authenticationToken  Obiekt obiekt zwrcony przez metod uwierzytelniajc.
    Protected MustOverride Sub NotifyAuthentication(ByVal authenticationToken As Object)
End Class 'AbstractLogon
